/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.dialogos.recap;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.validacion.ContextoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidableContexto;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloDialogo;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoBase;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.DetalleAir;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.valores.ModeloValoresAir;
import ec.gob.sri.dimm.ats.modelo.util.InfoPantallas;
import ec.gob.sri.dimm.ats.ui.dialogos.compras.DialogoDetalleAirCompra;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;

public class DialogoDetalleAir
extends DialogoBase
implements VistaModelo<DetalleAir>,
VistaValoresPropios {
    private DataBindingContext m_bindingContext;
    private ModeloValoresAir modeloValores;
    private ListenerValidacionModeloDialogo listenerValidacionModelo;
    private DetalleAir modeloDatos;
    private Text txtBaseImponible;
    private Text txtPorcentaje;
    private Text txtMontoRetencion;
    private ComboViewer cvConceptos;
    private boolean editando;
    private List<String> codigosExistentes;
    private String codigoActual = "";
    private final Periodo periodo;
    private final String esMicroEmpresa;
    private final Date fechaSelecContable;

    public DialogoDetalleAir(IWorkbenchPartSite site, boolean editando, List<String> codigosComp, Periodo periodo, String esMicroEmpresa, Date fechaSelecContable) {
        super(site);
        this.editando = editando;
        this.codigosExistentes = codigosComp;
        this.periodo = periodo;
        this.esMicroEmpresa = esMicroEmpresa;
        this.fechaSelecContable = fechaSelecContable;
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresAir(this.periodo, this.esMicroEmpresa, this.fechaSelecContable, null);
        this.modeloValores.inicializar();
    }

    protected void procesarSustentosEspeciales_323() {
        if (this.modeloDatos.getConceptoRetencion().equals(DialogoDetalleAirCompra.Sustentos.SUS_323E2.getCodigo())) {
            this.modeloDatos.setPorcentajeRetencion(DialogoDetalleAirCompra.Sustentos.SUS_323E2.getPorcentaje());
            this.txtPorcentaje.setEditable(DialogoDetalleAirCompra.Sustentos.SUS_323E2.isEditable());
        }
    }

    public void setModeloDatos(DetalleAir modeloDatos) {
        this.modeloDatos = modeloDatos;
        if (this.editando) {
            this.codigoActual = modeloDatos.getConceptoRetencion();
        }
    }

    public boolean close() {
        this.modeloDatos.removePropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        return super.close();
    }

    public void procesarModeloDatos() {
        String codigoTipoConcepto = this.modeloDatos.getConceptoRetencion();
        ElementoNombreValor tipoConcepto = this.modeloValores.obtenerTipoConcepto(codigoTipoConcepto);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvConceptos, (Object)tipoConcepto);
        if (tipoConcepto != null) {
            if (tipoConcepto.getEtiqueta().substring(0, 4).equals("504F") || tipoConcepto.getEtiqueta().substring(0, 4).equals("504H")) {
                this.txtPorcentaje.setEditable(true);
            } else {
                this.txtPorcentaje.setEditable(((String[])tipoConcepto.getValor())[1] == null);
            }
            this.procesarSustentosEspeciales_323();
        }
        ContextoValidacion ctx = new ContextoValidacion();
        ctx.agregar(InfoPantallas.AIR_ACTUAL.toString(), (Object)this.codigoActual);
        ctx.agregar(InfoPantallas.AIR_EXISTENTES.toString(), this.codigosExistentes);
        this.listenerValidacionModelo = new ListenerValidacionModeloDialogo((InformacionValidableContexto)this.modeloDatos, ctx, (DialogoBase)this);
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Retenci\u00f3n en la Fuente Impuesto a la Renta");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblConceptoDeRetencin = new Label(container, 0);
        lblConceptoDeRetencin.setText("Concepto de Retenci\u00f3n");
        this.cvConceptos = new ComboViewer(container, 8);
        this.cvConceptos.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoConcepto = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoConcepto != null) {
                    DialogoDetalleAir.this.modeloDatos.setConceptoRetencion(((String[])tipoConcepto.getValor())[0]);
                    DialogoDetalleAir.this.modeloDatos.setDescripcionConcepto(tipoConcepto.getNombre());
                    if (!DialogoDetalleAir.this.modeloDatos.getConceptoRetencion().equals(DialogoDetalleAir.this.codigoActual)) {
                        DialogoDetalleAir.this.modeloDatos.setPorcentajeRetencion(((String[])tipoConcepto.getValor())[1] == null ? "0.00" : ((String[])tipoConcepto.getValor())[1]);
                    }
                    if (tipoConcepto.getEtiqueta().substring(0, 4).equals("504F") || tipoConcepto.getEtiqueta().substring(0, 4).equals("504H")) {
                        DialogoDetalleAir.this.txtPorcentaje.setEditable(true);
                    } else {
                        DialogoDetalleAir.this.txtPorcentaje.setEditable(((String[])tipoConcepto.getValor())[1] == null);
                    }
                    DialogoDetalleAir.this.procesarSustentosEspeciales_323();
                }
            }
        });
        Combo combo = this.cvConceptos.getCombo();
        GridData gd_combo = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 150;
        combo.setLayoutData((Object)gd_combo);
        Label lblBaseImponibleImpuesto = new Label(container, 0);
        GridData gd_lblBaseImponibleImpuesto = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblBaseImponibleImpuesto.widthHint = 200;
        lblBaseImponibleImpuesto.setLayoutData((Object)gd_lblBaseImponibleImpuesto);
        lblBaseImponibleImpuesto.setText("Base Imponible Renta");
        this.txtBaseImponible = new Text(container, 2048);
        this.txtBaseImponible.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoDetalleAir.this.txtBaseImponible.selectAll();
            }
        });
        this.txtBaseImponible.setTextLimit(15);
        GridData gd_txtBaseImponible = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtBaseImponible.widthHint = 125;
        this.txtBaseImponible.setLayoutData((Object)gd_txtBaseImponible);
        Label lblPorcentajeRetencin = new Label(container, 0);
        lblPorcentajeRetencin.setText("Porcentaje Retenci\u00f3n");
        this.txtPorcentaje = new Text(container, 2048);
        this.txtPorcentaje.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoDetalleAir.this.txtPorcentaje.selectAll();
            }
        });
        this.txtPorcentaje.setTextLimit(5);
        GridData gd_txtPorcentaje = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtPorcentaje.widthHint = 125;
        this.txtPorcentaje.setLayoutData((Object)gd_txtPorcentaje);
        Label lblMontoDeRetencin = new Label(container, 0);
        lblMontoDeRetencin.setText("Monto de Retenci\u00f3n");
        this.txtMontoRetencion = new Text(container, 2048);
        this.txtMontoRetencion.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoDetalleAir.this.txtMontoRetencion.selectAll();
            }
        });
        this.txtMontoRetencion.setTextLimit(15);
        GridData gd_txtMontoRetencion = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtMontoRetencion.widthHint = 125;
        this.txtMontoRetencion.setLayoutData((Object)gd_txtMontoRetencion);
        this.m_bindingContext = this.initDataBindings();
        this.procesarModeloDatos();
        return area;
    }

    protected Point getInitialSize() {
        return new Point(660, 400);
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvConceptos.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvConceptos.setContentProvider((IContentProvider)listContentProvider);
        IObservableList tiposDeConceptosModeloValoresObserveList = PojoProperties.list((String)"tiposDeConceptos").observe((Object)this.modeloValores);
        this.cvConceptos.setInput((Object)tiposDeConceptosModeloValoresObserveList);
        ISWTObservableValue observeTextTxtBaseImponibleObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtBaseImponible);
        IObservableValue baseImponibleRentaModeloDatosObserveValue = BeanProperties.value((String)"baseImponibleRenta").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtBaseImponibleObserveWidget, baseImponibleRentaModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtMontoRetencionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtMontoRetencion);
        IObservableValue valorRetenidoModeloDatosObserveValue = BeanProperties.value((String)"valorRetenido").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtMontoRetencionObserveWidget, valorRetenidoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtPorcentajeObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtPorcentaje);
        IObservableValue porcentajeRetencionModeloDatosObserveValue = BeanProperties.value((String)"porcentajeRetencion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtPorcentajeObserveWidget, porcentajeRetencionModeloDatosObserveValue, null, null);
        return bindingContext;
    }
}

